ORCA/M Asm65816 2.1.0

0001 C8D6                       title 'Tool Locator--TextState' 
0002 C8D6              ****************************************************************
0003 C8D6              *                                                              *
0004 C8D6              *                      TextState                               *
0005 C8D6              *                                                              *
0006 C8D6              ****************************************************************
0007 C8D6
0008 C8D6
0009 C8D6              ****************************************************************
0010 C8D6              *                                                              *
0011 C8D6              *                   Copyright (C) 1985-1988,1991               *
0012 C8D6              *                   All Rights Reserved                        *
0013 C8D6              *                   Apple Computer, Inc.                       *
0014 C8D6              *                                                              *
0015 C8D6              ****************************************************************
0016 C8D6              *
0017 C8D6              * 6-Jun-91 Dave Lyons
0018 C8D6              *
0019 C8D6              * Text page 1 shadowing state (from bit 0 of $E0C035) is now
0020 C8D6              * stored in bit 0 of the s_80col byte in the Text State handle.
0021 C8D6              * SaveTextState saves the status and enables shadowing;
0022 C8D6              * RestoreTextState restores the old state.
0023 C8D6              *
0024 C8D6              * RestoreTextState(NIL) now does nothing.
0025 C8D6              *
0026 C8D6              ****************************************************************
0027 C8D6
0028 C8D6
0029 C8D6                       blanks off 
0030 C8D6                       string asis 
0031 C8D6
0032 C8D6                       print push 
0033 C8D6                       print off 
0034 C8D6                       include 'all.macros' 
0035 C8D6                       include '::sys.equs.asm' 
0036 C8D6                       INCLUDE 'e16.memory' 
0037 C8D6
0038 C8D6                       include 'tl.equates.asm' 
0039 C8D6                       print pop 
0040 C8D6
0041 C8D6
0042 C8D6
0043 C8D6
0044 C8D6                       title ' Imported Addresses' 
0045 C8D6              ;-----------------------------------------------
0046 C8D6              ;
0047 C8D6              ;   Imported addresses
0048 C8D6              ;
0049 C8D6              ;-----------------------------------------------
0050 C8D6
0051 C8D6                       IMPORT EndCall4 
0052 C8D6                       IMPORT EndCall8 
0053 C8D6                       IMPORT ErrOut4 
0054 C8D6                       IMPORT ErrOut8 
0055 C8D6                       IMPORT oBusyErr4 
0056 C8D6                       IMPORT oEndCall0 
0057 C8D6
0058 C8D6                       eject 
0059 C8D6              ****************************************************************
0060 C8D6              *
0061 C8D6              SaveTextState PROC EXPORT 
0062 C8D6              *
0063 C8D6              * Saves the text screen and releated variables into a buffer
0064 C8D6              * obtained from the memory manager.  Returns handle to buffer.
0065 C8D6              * 
0066 C8D6              * Inputs:
0067 C8D6              *                   none
0068 C8D6              *
0069 C8D6              * Outputs:
0070 C8D6              *                   StateHandle : long
0071 C8D6              *
0072 C8D6              * External Refs:
0073 C8D6              *                   none
0074 C8D6              *
0075 C8D6              * Entry Points:
0076 C8D6              *                   none
0077 C8D6              *
0078 C8D6                       longa on                       ; mode
0079 C8D6                       longi on
0080 C8D6              *
0081 C8D6              ****************************************************************
0082 C8D6
0083 C8D6
0084 C8D6                       DefineStack 
0085 C8D6              OrigDirect WORD 
0086 C8D6              StatePtr LONG 
0087 C8D6              RTL1     BLOCK 3 
0088 C8D6              RTL2     BLOCK 3 
0089 C8D6              StateHandle LONG 
0090 C8D6
0091 C8D6 48                    pha                            ; push 4 bytes on to use as
0092 C8D7 48                    pha                            ; StatePtr
0093 C8D8 0B                    phd   
0094 C8D9 3B                    tsc   
0095 C8DA 5B                    tcd   
0096 C8DB
0097 C8DB 8B                    phb                            ; save data bank
0098 C8DC F4 E0 E0              pea   $E0E0                    ; set it to bank e0
0099 C8DF AB                    plb   
0100 C8E0 AB                    plb   
0101 C8E1
0102 C8E1              ; Get Memory
0103 C8E1
0104 C8E1 48                    pha   
0105 C8E2 48                    pha   
0106 C8E3 F4 00 00 F4           PushLong #SizeStateRecord 
0107 C8E9 F4 01 90              PushWord #TLUserID 
0108 C8EC F4 00 00              PushWord #$0000 
0109 C8EF F4 00 00 F4           PushLong #0 
0110 C8F5 A2 02 09 22           _NewHandle 
0111 C8FC 90 06                 bcc   NoMemError
0112 C8FE FA                    plx   
0113 C8FF FA                    plx   
0114 C900 AA                    tax                            ; put error in x
0115 C901 82 EA 00              brl   GetOutNow
0116 C904
0117 C904 68           NoMemError pla   
0118 C905 85 0D                 sta   StateHandle
0119 C907 68                    pla   
0120 C908 85 0F                 sta   StateHandle+2
0121 C90A
0122 C90A A7 0D                 lda   [StateHandle]
0123 C90C 85 03                 sta   StatePtr
0124 C90E A0 02 00              ldy   #2
0125 C911 B7 0D                 lda   [StateHandle],y
0126 C913 85 05                 sta   StatePtr+2
0127 C915
0128 C915
0129 C915              ; Now save important zero page information relating to
0130 C915              ; state of firmware.
0131 C915
0132 C915 E2 30                 sep   #$30
0133 C917                       longa off
0134 C917                       longi off
0135 C917
0136 C917              ; Make sure that main memory, etc is set correctly.
0137 C917
0138 C917 AD 68 C0              lda   |statereg                ; get memory state
0139 C91A A0 00                 ldy   #s_statereg              ; put into memory block
0140 C91C 97 03                 sta   [StatePtr],y
0141 C91E
0142 C91E              ; Save the video mode softswitches.
0143 C91E
0144 C91E AD 18 C0              lda   |rd80col
0145 C921 A0 01                 ldy   #s_80Col
0146 C923 97 03                 sta   [StatePtr],y
0147 C925
0148 C925 AD 29 C0              lda   |newvideo
0149 C928 A0 02                 ldy   #s_NewVideo
0150 C92A 97 03                 sta   [StatePtr],y
0151 C92C
0152 C92C              ;----------------------------------------------------------
0153 C92C              ;
0154 C92C              ; Note that we take advantage of the fact that these next
0155 C92C              ; six soft switches line up just right and can be read
0156 C92C              ; two at a time.  (We also made sure that they lined up
0157 C92C              ; in the state record too.)
0158 C92C
0159 C92C C2 30                 rep   #$30
0160 C92E                       longa on
0161 C92E                       longi on
0162 C92E
0163 C92E AD 1A C0              lda   |rdtext                  ;save rdtext and rdmix
0164 C931 A0 03 00              ldy   #s_text
0165 C934 97 03                 sta   [StatePtr],y
0166 C936
0167 C936 AD 1C C0              lda   |rdpage2                 ;save rdpage2 and rdhires
0168 C939 A0 05 00              ldy   #s_Page2
0169 C93C 97 03                 sta   [StatePtr],y
0170 C93E
0171 C93E AD 1E C0              lda   |altcharset              ;save altcharset and rd80vid
0172 C941 A0 07 00              ldy   #s_altCharSet
0173 C944 97 03                 sta   [StatePtr],y
0174 C946
0175 C946
0176 C946              ;----------------------------------------------------------
0177 C946              ;
0178 C946              ; I don't know why this one is a word, but it is!
0179 C946
0180 C946 AF 35 01 E1           lda   >cursor
0181 C94A A0 09 00              ldy   #s_Cursor
0182 C94D 97 03                 sta   [StatePtr],y
0183 C94F
0184 C94F              ;----------------------------------------------------------
0185 C94F              ;
0186 C94F              ; Note that I go into mixed mode here--long index but short
0187 C94F              ; memory.
0188 C94F
0189 C94F E2 20                 sep   #%00100000
0190 C951                       longa off
0191 C951
0192 C951 AD 17 C0              lda   |rdc3rom
0193 C954 A0 0B 00              ldy   #s_c3rom
0194 C957 97 03                 sta   [StatePtr],y
0195 C959
0196 C959
0197 C959              ;----------------------------------------------------------
0198 C959              ;
0199 C959              ; Back to full 16 bit mode!
0200 C959              ;
0201 C959 C2 20                 rep   #%00100000
0202 C95B                       longa on
0203 C95B
0204 C95B
0205 C95B              ;----------------------------------------------------------
0206 C95B              ;
0207 C95B              ; Now we save All of zero page!!!!
0208 C95B              ;
0209 C95B A2 00 00              ldx   #0
0210 C95E A0 20 00              ldy   #s_ZeroPage
0211 C961 BF 00 00 00  ZPLoop   lda   >0,x
0212 C965 97 03                 sta   [StatePtr],y
0213 C967 C8                    iny   
0214 C968 C8                    iny   
0215 C969 E8                    inx   
0216 C96A E8                    inx   
0217 C96B E0 00 01              cpx   #256
0218 C96E 90 F1                 bcc   ZPLoop
0219 C970
0220 C970              ;----------------------------------------------------------
0221 C970              ;
0222 C970              ; Now we set the video to be the way we want it!
0223 C970              ;
0224 C970 E2 30                 sep   #$30
0225 C972                       longa off
0226 C972                       longi off
0227 C972
0228 C972 AD 29 C0              lda   |newvideo
0229 C975 29 7F                 and   #%01111111
0230 C977 8D 29 C0              sta   |newvideo
0231 C97A 8D 51 C0              sta   |txtset
0232 C97D 8D 52 C0              sta   |mixclr
0233 C980 8D 54 C0              sta   |txtpage1
0234 C983
0235 C983              ;----------------------------------------------------------
0236 C983              ;
0237 C983              ; Set Normal video (not inverse/flash)
0238 C983              ;
0239 C983
0240 C983 A9 FF                 lda   #$FF
0241 C985 8F 32 00 00           sta   >$000032                 ; inverse switch
0242 C989
0243 C989
0244 C989              ;----------------------------------------------------------
0245 C989              ;
0246 C989              ; Back to full native to get the text tool global variables
0247 C989              ;
0248 C989
0249 C989 C2 30                 rep   #$30
0250 C98B                       longa on
0251 C98B                       longi on
0252 C98B
0253 C98B 48                    pha                            ; Start with output device
0254 C98C 48                    pha   
0255 C98D 48                    pha   
0256 C98E A2 0C 13 22           _GetOutputDevice 
0257 C995 A0 0C 00              ldy   #s_OutputDevice
0258 C998 68                    pla   
0259 C999 97 03                 sta   [StatePtr],y
0260 C99B C8                    iny   
0261 C99C C8                    iny   
0262 C99D 68                    pla   
0263 C99E 97 03                 sta   [StatePtr],y
0264 C9A0 C8                    iny   
0265 C9A1 C8                    iny   
0266 C9A2 68                    pla   
0267 C9A3 97 03                 sta   [StatePtr],y
0268 C9A5
0269 C9A5 48                    pha                            ; now the output globals
0270 C9A6 48                    pha   
0271 C9A7 A2 0C 0D 22           _GetOutGlobals 
0272 C9AE A0 12 00              ldy   #s_OutGlobals
0273 C9B1 68                    pla   
0274 C9B2 97 03                 sta   [StatePtr],y
0275 C9B4 68                    pla   
0276 C9B5 C8                    iny   
0277 C9B6 C8                    iny   
0278 C9B7 97 03                 sta   [StatePtr],y
0279 C9B9
0280 C9B9
0281 C9B9 48                    pha                            ; Next the input device
0282 C9BA 48                    pha   
0283 C9BB 48                    pha   
0284 C9BC A2 0C 12 22           _GetInputDevice 
0285 C9C3 A0 16 00              ldy   #s_InputDevice
0286 C9C6 68                    pla   
0287 C9C7 97 03                 sta   [StatePtr],y
0288 C9C9 C8                    iny   
0289 C9CA C8                    iny   
0290 C9CB 68                    pla   
0291 C9CC 97 03                 sta   [StatePtr],y
0292 C9CE C8                    iny   
0293 C9CF C8                    iny   
0294 C9D0 68                    pla   
0295 C9D1 97 03                 sta   [StatePtr],y
0296 C9D3
0297 C9D3
0298 C9D3 48                    pha                            ; finally, the intput globals too
0299 C9D4 48                    pha   
0300 C9D5 A2 0C 0C 22           _GetInGlobals 
0301 C9DC A0 1C 00              ldy   #s_InGlobals
0302 C9DF 68                    pla   
0303 C9E0 97 03                 sta   [StatePtr],y
0304 C9E2 C8                    iny   
0305 C9E3 C8                    iny   
0306 C9E4 68                    pla   
0307 C9E5 97 03                 sta   [StatePtr],y
0308 C9E7
0309 C9E7
0310 C9E7              ;----------------------------------------------------------
0311 C9E7              ;
0312 C9E7              ; Finally, we save the screen contents.
0313 C9E7              ;
0314 C9E7              ; Note that I save the entire screen including screen
0315 C9E7              ; holes.  But I carefully refrain from putting back
0316 C9E7              ; any of the screen holes except for slot 3.
0317 C9E7              ;
0318 C9E7
0319 C9E7 22 F7 C9 FD           jsl   SaveTheScreen
0320 C9EB
0321 C9EB A2 00 00              ldx   #0                       ; signal no error
0322 C9EE
0323 C9EE AB           GetOutNow plb                           ; restore the data bank
0324 C9EF 2B                    pld                            ; restore direct page reg
0325 C9F0
0326 C9F0 68                    pla                            ; get rid of pointer
0327 C9F1 68                    pla   
0328 C9F2
0329 C9F2 8A                    txa   
0330 C9F3 C9 01 00              cmp   #1
0331 C9F6 6B                    rtl   
0332 C9F7
0333 C9F7              ;----------------------------------------------------------
0334 C9F7              ;
0335 C9F7              ; SaveTheScreen
0336 C9F7              ;
0337 C9F7 A2 00 00     SaveTheScreen ldx   #0
0338 C9FA A0 20 01              ldy   #s_TextBank0
0339 C9FD BF 00 04 00  B0Loop   lda   >$000400,x
0340 CA01 97 03                 sta   [StatePtr],y
0341 CA03 C8                    iny   
0342 CA04 C8                    iny   
0343 CA05 E8                    inx   
0344 CA06 E8                    inx   
0345 CA07 E0 00 04              cpx   #$400
0346 CA0A 90 F1                 bcc   B0Loop
0347 CA0C
0348 CA0C A2 00 00              ldx   #0
0349 CA0F A0 20 05              ldy   #s_TextBank1
0350 CA12 BF 00 04 01  B1Loop   lda   >$010400,x
0351 CA16 97 03                 sta   [StatePtr],y
0352 CA18 C8                    iny   
0353 CA19 C8                    iny   
0354 CA1A E8                    inx   
0355 CA1B E8                    inx   
0356 CA1C E0 00 04              cpx   #$400
0357 CA1F 90 F1                 bcc   B1Loop
0358 CA21
0359 CA21 A2 00 00              ldx   #0
0360 CA24 A0 20 09              ldy   #s_TextBankE0
0361 CA27 BF 00 04 E0  BE0Loop  lda   >$E00400,x
0362 CA2B 97 03                 sta   [StatePtr],y
0363 CA2D C8                    iny   
0364 CA2E C8                    iny   
0365 CA2F E8                    inx   
0366 CA30 E8                    inx   
0367 CA31 E0 00 04              cpx   #$400
0368 CA34 90 F1                 bcc   BE0Loop
0369 CA36
0370 CA36 A2 00 00              ldx   #0
0371 CA39 A0 20 0D              ldy   #s_TextBankE1
0372 CA3C BF 00 04 E1  BE1Loop  lda   >$E10400,x
0373 CA40 97 03                 sta   [StatePtr],y
0374 CA42 C8                    iny   
0375 CA43 C8                    iny   
0376 CA44 E8                    inx   
0377 CA45 E8                    inx   
0378 CA46 E0 00 04              cpx   #$400
0379 CA49 90 F1                 bcc   BE1Loop
0380 CA4B
0381 CA4B 6B                    rtl   
0382 CA4C
0383 CA4C                       ENDP 
0384 CA4C
0385 CA4C
0386 CA4C              ****************************************************************
0387 CA4C              *
0388 CA4C              RestoreTextState PROC EXPORT 
0389 CA4C              *
0390 CA4C              * Restores text screen and related variables from handle 
0391 CA4C              * passed by user.  (Handle should have been created by SaveTextState
0392 CA4C              * call.)  Disposes of handle.
0393 CA4C              *
0394 CA4C              *
0395 CA4C              * Inputs:
0396 CA4C              *                   ScreenDataHandle : long
0397 CA4C              *
0398 CA4C              * Outputs:
0399 CA4C              *                   none
0400 CA4C              *
0401 CA4C              * External Refs:
0402 CA4C              *                   none
0403 CA4C              *
0404 CA4C              * Entry Points:
0405 CA4C              *                   none
0406 CA4C              *
0407 CA4C                       longa on                       ; mode
0408 CA4C                       longi on
0409 CA4C              *
0410 CA4C              ****************************************************************
0411 CA4C
0412 CA4C
0413 CA4C
0414 CA4C                       DefineStack 
0415 CA4C              OrigDirect WORD 
0416 CA4C              StatePtr LONG 
0417 CA4C              RTL1     BLOCK 3 
0418 CA4C              RTL2     BLOCK 3 
0419 CA4C              StateHandle LONG 
0420 CA4C
0421 CA4C 48                    pha                            ; push 4 bytes on to use as
0422 CA4D 48                    pha                            ; StatePtr
0423 CA4E 0B                    phd   
0424 CA4F 3B                    tsc   
0425 CA50 5B                    tcd   
0426 CA51
0427 CA51 8B                    phb                            ; save data bank
0428 CA52 F4 E0 E0              pea   $E0E0                    ; set it to bank e0
0429 CA55 AB                    plb   
0430 CA56 AB                    plb   
0431 CA57
0432 CA57              ;----------------------------------------------------------
0433 CA57              ;
0434 CA57              ; Dereference the state record handle.
0435 CA57              ;
0436 CA57 A7 0D                 lda   [StateHandle]
0437 CA59 85 03                 sta   StatePtr
0438 CA5B A0 02 00              ldy   #2
0439 CA5E B7 0D                 lda   [StateHandle],y
0440 CA60 85 05                 sta   StatePtr+2
0441 CA62
0442 CA62
0443 CA62              ; Now save important zero page information relating to
0444 CA62              ; state of firmware.
0445 CA62
0446 CA62 E2 30                 sep   #$30
0447 CA64                       longa off
0448 CA64                       longi off
0449 CA64
0450 CA64              ; Now the video mode switches
0451 CA64
0452 CA64 A0 01                 ldy   #s_80Col
0453 CA66 B7 03                 lda   [StatePtr],y
0454 CA68 10 05                 bpl   Clear80Col
0455 CA6A 8D 01 C0              sta   |Set80Col
0456 CA6D 80 03                 bra   Done80Col
0457 CA6F 8D 00 C0     Clear80Col sta   |Clr80Col
0458 CA72              Done80Col                               ; 
0459 CA72
0460 CA72 A0 08                 ldy   #s_80Vid
0461 CA74 B7 03                 lda   [StatePtr],y
0462 CA76 10 05                 bpl   Clear80Vid
0463 CA78 8D 0D C0              sta   |Set80Vid
0464 CA7B 80 03                 bra   Done80Vid
0465 CA7D 8D 0C C0     Clear80Vid sta   |Clr80Vid
0466 CA80              Done80Vid                               ; 
0467 CA80
0468 CA80 A0 02                 ldy   #s_NewVideo              ; new video
0469 CA82 B7 03                 lda   [StatePtr],y
0470 CA84 29 C0                 and   #$C0
0471 CA86 0D 29 C0              ora   |newvideo
0472 CA89 8D 29 C0              sta   |newvideo
0473 CA8C
0474 CA8C A0 03                 ldy   #s_text                  ; text
0475 CA8E B7 03                 lda   [StatePtr],y
0476 CA90 10 05                 bpl   ClearText
0477 CA92 8D 51 C0              sta   |txtset
0478 CA95 80 03                 bra   DoneText
0479 CA97 8D 50 C0     ClearText sta   |txtclr
0480 CA9A              DoneText                                ; 
0481 CA9A
0482 CA9A A0 04                 ldy   #s_mix                   ; text mix
0483 CA9C B7 03                 lda   [StatePtr],y
0484 CA9E 10 05                 bpl   ClearMix
0485 CAA0 8D 53 C0              sta   |MixSet
0486 CAA3 80 03                 bra   DoneMix
0487 CAA5 8D 52 C0     ClearMix sta   |MixClr
0488 CAA8              DoneMix                                 ; 
0489 CAA8
0490 CAA8 A0 05                 ldy   #s_Page2                 ; page 2
0491 CAAA B7 03                 lda   [StatePtr],y
0492 CAAC 10 05                 bpl   DoPage1
0493 CAAE 8D 55 C0              sta   |TxtPage2
0494 CAB1 80 03                 bra   DonePage
0495 CAB3 8D 54 C0     DoPage1  sta   |TxtPage1
0496 CAB6              DonePage                                ; 
0497 CAB6
0498 CAB6 A0 06                 ldy   #s_Hires                 ; hires
0499 CAB8 B7 03                 lda   [StatePtr],y
0500 CABA 10 05                 bpl   DoLoRes
0501 CABC 8D 57 C0              sta   |hires
0502 CABF 80 03                 bra   DoneHires
0503 CAC1 8D 56 C0     DoLoRes  sta   |lores
0504 CAC4              DoneHires                               ; 
0505 CAC4
0506 CAC4 A0 07                 ldy   #s_altCharSet            ; alternate character set.
0507 CAC6 B7 03                 lda   [StatePtr],y
0508 CAC8 10 05                 bpl   ClearAC
0509 CACA 8D 0F C0              sta   |setaltchar
0510 CACD 80 03                 bra   DoneAltChar
0511 CACF 8D 0E C0     ClearAC  sta   |ClrAltChar
0512 CAD2              DoneAltChar                             ; 
0513 CAD2 8D 1E C0              sta   |altcharset
0514 CAD5
0515 CAD5 A0 0B                 ldy   #s_c3rom                 ; slot 3 rom
0516 CAD7 B7 03                 lda   [StatePtr],y
0517 CAD9 10 05                 bpl   DoInternal
0518 CADB 8D 0B C0              sta   |setslotc3rom
0519 CADE 80 03                 bra   DoneSlot3
0520 CAE0 8D 0A C0     DoInternal sta   |setintc3rom
0521 CAE3              DoneSlot3                               ; 
0522 CAE3
0523 CAE3              ;----------------------------------------------------------
0524 CAE3              ;
0525 CAE3              ; Retore the State register
0526 CAE3              ;
0527 CAE3 A0 00                 ldy   #s_statereg
0528 CAE5 B7 03                 lda   [StatePtr],y
0529 CAE7 8D 68 C0              sta   |statereg
0530 CAEA
0531 CAEA
0532 CAEA C2 30                 rep   #$30
0533 CAEC                       longa on
0534 CAEC                       longi on
0535 CAEC
0536 CAEC              ;----------------------------------------------------------
0537 CAEC              ;
0538 CAEC              ; I don't know why this one is a word, but it is!
0539 CAEC
0540 CAEC A0 09 00              ldy   #s_Cursor
0541 CAEF B7 03                 lda   [StatePtr],y
0542 CAF1 8F 35 01 E1           sta   >cursor
0543 CAF5
0544 CAF5
0545 CAF5              ;----------------------------------------------------------
0546 CAF5              ;
0547 CAF5              ; Now we restore All of zero page!!!!
0548 CAF5              ;
0549 CAF5 A2 00 00              ldx   #0
0550 CAF8 A0 20 00              ldy   #s_ZeroPage
0551 CAFB B7 03        ZPLoop   lda   [StatePtr],y
0552 CAFD 9F 00 00 00           sta   >0,x
0553 CB01 C8                    iny   
0554 CB02 C8                    iny   
0555 CB03 E8                    inx   
0556 CB04 E8                    inx   
0557 CB05 E0 00 01              cpx   #256
0558 CB08 90 F1                 bcc   ZPLoop
0559 CB0A
0560 CB0A
0561 CB0A              ;----------------------------------------------------------
0562 CB0A              ;
0563 CB0A              ; Back to full native to get the text tool global variables
0564 CB0A              ;
0565 CB0A
0566 CB0A C2 30                 rep   #$30
0567 CB0C                       longa on
0568 CB0C                       longi on
0569 CB0C
0570 CB0C A0 10 00              ldy   #s_OutputDevice+4
0571 CB0F B7 03                 lda   [StatePtr],y
0572 CB11 48                    pha   
0573 CB12 88                    dey   
0574 CB13 88                    dey   
0575 CB14 B7 03                 lda   [StatePtr],y
0576 CB16 48                    pha   
0577 CB17 88                    dey   
0578 CB18 88                    dey   
0579 CB19 B7 03                 lda   [StatePtr],y
0580 CB1B 48                    pha   
0581 CB1C A2 0C 10 22           _SetOutputDevice 
0582 CB23
0583 CB23 A0 14 00              ldy   #s_OutGlobals+2
0584 CB26 B7 03                 lda   [StatePtr],y
0585 CB28 48                    pha   
0586 CB29 88                    dey   
0587 CB2A 88                    dey   
0588 CB2B B7 03                 lda   [StatePtr],y
0589 CB2D 48                    pha   
0590 CB2E A2 0C 0A 22           _SetOutGlobals 
0591 CB35
0592 CB35
0593 CB35 A0 1A 00              ldy   #s_InputDevice+4
0594 CB38 B7 03                 lda   [StatePtr],y
0595 CB3A 48                    pha   
0596 CB3B 88                    dey   
0597 CB3C 88                    dey   
0598 CB3D B7 03                 lda   [StatePtr],y
0599 CB3F 48                    pha   
0600 CB40 88                    dey   
0601 CB41 88                    dey   
0602 CB42 B7 03                 lda   [StatePtr],y
0603 CB44 48                    pha   
0604 CB45 A2 0C 0F 22           _SetInputDevice 
0605 CB4C
0606 CB4C A0 1E 00              ldy   #s_InGlobals+2
0607 CB4F B7 03                 lda   [StatePtr],y
0608 CB51 48                    pha   
0609 CB52 88                    dey   
0610 CB53 88                    dey   
0611 CB54 B7 03                 lda   [StatePtr],y
0612 CB56 48                    pha                            ; now the output globals
0613 CB57 A2 0C 09 22           _SetInGlobals 
0614 CB5E
0615 CB5E
0616 CB5E              ;----------------------------------------------------------
0617 CB5E              ;
0618 CB5E              ; Finally, we restore the screen contents.
0619 CB5E              ;
0620 CB5E              ; Note that I save the current screen holes on the stack
0621 CB5E              ; restore the entire screen and then restore the screen
0622 CB5E              ; holes.
0623 CB5E              ;
0624 CB5E 08                    php                            ; save int state
0625 CB5F 78                    sei                            ; off the ints!
0626 CB60
0627 CB60 20 D7 CB              jsr   SaveScreenHoles
0628 CB63
0629 CB63 22 82 CB FD           jsl   RepTheScreen
0630 CB67
0631 CB67 20 14 CC              jsr   RestoreScreenHoles
0632 CB6A
0633 CB6A 28                    plp                            ; restore int state!
0634 CB6B
0635 CB6B D4 0F                 pei   StateHandle+2
0636 CB6D D4 0D                 pei   StateHandle
0637 CB6F A2 02 10 22           _DisposeHandle 
0638 CB76 AA                    tax   
0639 CB77
0640 CB77 AB           ExitRestTextState plb                   ; restore the data bank
0641 CB78 2B                    pld                            ; restore direct page reg
0642 CB79
0643 CB79 68                    pla                            ; get rid of pointer
0644 CB7A 68                    pla   
0645 CB7B
0646 CB7B A0 04 00              ldy   #4
0647 CB7E 5C 84 01 E1           jml   ToStrip
0648 CB82
0649 CB82              ;----------------------------------------------------------
0650 CB82              ;
0651 CB82              ; RepTheScreen
0652 CB82              ;
0653 CB82 A2 00 00     RepTheScreen ldx   #0
0654 CB85 A0 20 01              ldy   #s_TextBank0
0655 CB88 B7 03        B0Loop   lda   [StatePtr],y
0656 CB8A 9F 00 04 00           sta   >$000400,x
0657 CB8E C8                    iny   
0658 CB8F C8                    iny   
0659 CB90 E8                    inx   
0660 CB91 E8                    inx   
0661 CB92 E0 00 04              cpx   #$400
0662 CB95 90 F1                 bcc   B0Loop
0663 CB97
0664 CB97 A2 00 00              ldx   #0
0665 CB9A A0 20 05              ldy   #s_TextBank1
0666 CB9D B7 03        B1Loop   lda   [StatePtr],y
0667 CB9F 9F 00 04 01           sta   >$010400,x
0668 CBA3 C8                    iny   
0669 CBA4 C8                    iny   
0670 CBA5 E8                    inx   
0671 CBA6 E8                    inx   
0672 CBA7 E0 00 04              cpx   #$400
0673 CBAA 90 F1                 bcc   B1Loop
0674 CBAC
0675 CBAC A2 00 00              ldx   #0
0676 CBAF A0 20 09              ldy   #s_TextBankE0
0677 CBB2 B7 03        BE0Loop  lda   [StatePtr],y
0678 CBB4 9F 00 04 E0           sta   >$E00400,x
0679 CBB8 C8                    iny   
0680 CBB9 C8                    iny   
0681 CBBA E8                    inx   
0682 CBBB E8                    inx   
0683 CBBC E0 00 04              cpx   #$400
0684 CBBF 90 F1                 bcc   BE0Loop
0685 CBC1
0686 CBC1 A2 00 00              ldx   #0
0687 CBC4 A0 20 0D              ldy   #s_TextBankE1
0688 CBC7 B7 03        BE1Loop  lda   [StatePtr],y
0689 CBC9 9F 00 04 E1           sta   >$E10400,x
0690 CBCD C8                    iny   
0691 CBCE C8                    iny   
0692 CBCF E8                    inx   
0693 CBD0 E8                    inx   
0694 CBD1 E0 00 04              cpx   #$400
0695 CBD4 90 F1                 bcc   BE1Loop
0696 CBD6
0697 CBD6 6B                    rtl   
0698 CBD7
0699 CBD7              ;----------------------------------------------------------
0700 CBD7              ;
0701 CBD7              ; Routines to save and restore screen holes
0702 CBD7              ;
0703 CBD7              SaveScreenHoles                         ; 
0704 CBD7 7A                    ply                            ; get rts address off stack
0705 CBD8
0706 CBD8              ; Warning: mixed mode again!!!!
0707 CBD8 E2 20                 sep   #%00100000
0708 CBDA                       longa off
0709 CBDA A2 01 00              ldx   #1                       ; start with slot 1
0710 CBDD              SaveLoop                                ; 
0711 CBDD E0 03 00              cpx   #3
0712 CBE0 F0 28                 beq   Skip3Save
0713 CBE2 BF 78 04 00           lda   >$000478,x
0714 CBE6 48                    pha   
0715 CBE7 BF F8 04 00           lda   >$0004F8,x
0716 CBEB 48                    pha   
0717 CBEC BF 78 05 00           lda   >$000578,x
0718 CBF0 48                    pha   
0719 CBF1 BF F8 05 00           lda   >$0005F8,x
0720 CBF5 48                    pha   
0721 CBF6 BF 78 06 00           lda   >$000678,x
0722 CBFA 48                    pha   
0723 CBFB BF F8 06 00           lda   >$0006F8,x
0724 CBFF 48                    pha   
0725 CC00 BF 78 07 00           lda   >$000778,x
0726 CC04 48                    pha   
0727 CC05 BF F8 07 00           lda   >$0007F8,x
0728 CC09 48                    pha   
0729 CC0A E8           Skip3Save inx   
0730 CC0B E0 08 00              cpx   #8
0731 CC0E 90 CD                 bcc   SaveLoop
0732 CC10 C2 30                 rep   #$30                     ; put rts adr back on the stack
0733 CC12                       longa on
0734 CC12                       longi on
0735 CC12 5A                    phy   
0736 CC13 60                    rts   
0737 CC14
0738 CC14              RestoreScreenHoles                      ; 
0739 CC14 7A                    ply                            ; get rts address off stack
0740 CC15              ; Warning: mixed mode again!!!!
0741 CC15
0742 CC15 E2 20                 sep   #%00100000
0743 CC17                       longa off
0744 CC17
0745 CC17 A2 07 00              ldx   #7                       ; start with slot 7 when restoreing
0746 CC1A
0747 CC1A              RepLoop                                 ; 
0748 CC1A E0 03 00              cpx   #3
0749 CC1D F0 28                 beq   Skip3Rep
0750 CC1F 68                    pla   
0751 CC20 9F F8 07 00           sta   >$0007F8,x
0752 CC24 68                    pla   
0753 CC25 9F 78 07 00           sta   >$000778,x
0754 CC29 68                    pla   
0755 CC2A 9F F8 06 00           sta   >$0006F8,x
0756 CC2E 68                    pla   
0757 CC2F 9F 78 06 00           sta   >$000678,x
0758 CC33 68                    pla   
0759 CC34 9F F8 05 00           sta   >$0005F8,x
0760 CC38 68                    pla   
0761 CC39 9F 78 05 00           sta   >$000578,x
0762 CC3D 68                    pla   
0763 CC3E 9F F8 04 00           sta   >$0004F8,x
0764 CC42 68                    pla   
0765 CC43 9F 78 04 00           sta   >$000478,x
0766 CC47 CA           Skip3Rep dex   
0767 CC48 D0 D0                 bne   RepLoop
0768 CC4A C2 30                 rep   #$30                     ; put rts adr back on the stack
0769 CC4C                       longa on
0770 CC4C                       longi on
0771 CC4C 5A                    phy   
0772 CC4D 60                    rts   
0773 CC4E
0774 CC4E
0775 CC4E                       ENDP 
0776 CC4E
0777 CC4E                       END   
